//Window_MenuCommand is actually the window for showing characters in your party!

Window_Command.prototype.windowHeight = function() {
    return (this.numVisibleRows() * 72) + this.standardPadding() * 2;
//    return this.fittingHeight(this.numVisibleRows());
};

Scene_Menu.prototype.create = function() {
	
		if ($gameSelfSwitches.value([4, 20, 'A'])) { //ng+ active
			$gameSwitches.setValue(179, true) //show hud stats
		}
		Scene_MenuBase.prototype.create.call(this);

		this.createCommandWindow();
		this._statesWindow = new Window_MenuStates(62, 195);
		this.addWindow(this._statesWindow);
//		this._commandWindow._statesWindow = this._statesWindow

		if (ConfigManager.touchbuttons) {
			this.sprite = new Sprite(ImageManager.loadPicture('zBtnBack'))
			this.sprite.x = -ConfigManager.movebtn //move x
			this.spritebtn = new Sprite(ImageManager.loadPicture('zBtnPrevNextMainMenu'))
			this.spritebtnU = new Sprite(ImageManager.loadPicture('zBtnPrevNextMainMenuU'))
			this.spritebtnD = new Sprite(ImageManager.loadPicture('zBtnPrevNextMainMenuD'))

			this.spritebtn.visible = false
			this.spritebtnU.visible = false
			this.spritebtnD.visible = false

			this.addChild(this.sprite)
			this.addChild(this.spritebtn)
			this.addChild(this.spritebtnU)
			this.addChild(this.spritebtnD)
		}
		
		$gameScreen.erasePicture(566) //erase clothes preview
		$gameScreen.erasePicture(565)
		$gameScreen.erasePicture(564)
		$gameScreen.erasePicture(128)
		
		if (!ConfigManager.port) { //don't show player portrait
			for (var i = 106; i <= 453; i++) {				$gameScreen.erasePicture(i)			}
			for (var i = 466; i <= 581; i++) {				$gameScreen.erasePicture(i)			}
		}
		else {
			if ($gameVariables.value(96) != 0) { //done chara creation
				storecl()
				restorecl()
				clothing_tags()
				resetbody()
				setexp()
			}
		}
};

var nk_Scene_Menu_keypress = Scene_Menu.prototype.update
Scene_Menu.prototype.update = function() {
    if (Input.isRepeated('pageup')) {
		if (this._statesWindow.topRow() > 0) {
			SoundManager.playCursor();
			this._statesWindow.setTopRow(this._statesWindow.topRow() - this._statesWindow.maxPageRows());
		}
	}
	else if (Input.isRepeated('pagedown')) {
		if (this._statesWindow.topRow() + this._statesWindow.maxPageRows() < this._statesWindow.maxRows()) {
			SoundManager.playCursor();
			this._statesWindow.setTopRow(this._statesWindow.topRow() + this._statesWindow.maxPageRows());
		}
	}
/*	else if (Input.isRepeated('up')) {
		this._statesWindow.activate()
	}*/
	
	
	if (ConfigManager.touchbuttons && this._statesWindow) {
		if ($gameActors.actor(1)._states.length >= 8) {
			var topRow = this._statesWindow.topRow();
			var maxTopRow = this._statesWindow.maxTopRow();
			if (maxTopRow > 0 && topRow < maxTopRow && topRow > 0) {
				this.spritebtn.visible = true
				this.spritebtnU.visible = false
				this.spritebtnD.visible = false
			}
			else if (topRow > 0) {
				this.spritebtn.visible = false
				this.spritebtnU.visible = true
				this.spritebtnD.visible = false
			}
			else if (maxTopRow > 0 && topRow < maxTopRow) {
				this.spritebtn.visible = false
				this.spritebtnU.visible = false
				this.spritebtnD.visible = true
			}
		}
		else {
			this.spritebtn.visible = false
			this.spritebtnU.visible = false
			this.spritebtnD.visible = false
		}
	}

	
    nk_Scene_Menu_keypress.call(this);
}

Scene_Menu.prototype.createCommandWindow = function() {
    this._commandWindow = new Window_MenuCommand(62, 0);
    this._commandWindow.setHandler('item',      this.commandItem.bind(this));
    this._commandWindow.setHandler('equip',     this.commandEquip.bind(this));
    this._commandWindow.setHandler('skill',     this.commandSkill.bind(this));
    this._commandWindow.setHandler('sanctum',   this.commandSanctum.bind(this));
    this._commandWindow.setHandler('save',      this.commandSave.bind(this));
    this._commandWindow.setHandler('load',      this.commandLoad.bind(this));
    this._commandWindow.setHandler('options',   this.commandOptions.bind(this));
    this._commandWindow.setHandler('gameEnd',   this.commandGameEnd.bind(this));
    this._commandWindow.setHandler('cancel',    this.closeMainMenu.bind(this));
    this.addWindow(this._commandWindow);
};

Scene_Menu.prototype.closeMainMenu = function() {
  this.popScene();
  $gameTemp.reserveCommonEvent(99);
};

Scene_Menu.prototype.commandSkill = function() {
  SceneManager.push(Scene_Skill);
};

Scene_Menu.prototype.commandEquip = function() {
  SceneManager.push(Scene_Equip);
};

Scene_Menu.prototype.commandLoad = function() {
    SceneManager.push(Scene_Load);
};

Scene_Menu.prototype.commandSanctum = function() {
	this.popScene()
	$gameTemp.reserveCommonEvent(100);
};



Window_MenuCommand.prototype.makeCommandList = function() {
	this.addCommand("Items", 'item', !$gameSwitches.value(25));
	this.addCommand("Wear", 'equip', !$gameSwitches.value(26));
	this.addCommand("Skills", 'skill', !$gameSwitches.value(23));
	this.addCommand("Options", 'options', navigator.cookieEnabled);
	this.addCommand("Save", 'save', this.isSaveEnabled());
	this.addCommand("Load", 'load');
	this.addCommand("Sanctum", 'sanctum', !$gameSwitches.value(24));
	this.addCommand("Quit", 'gameEnd');
};

Window_Command.prototype.drawItem = function(index) {
   var rect = this.itemRectForText(index);
   this.resetTextColor();
   this.changePaintOpacity(this.isCommandEnabled(index));
	 if (Utils.isMobileDevice()) {this.contents.fontSize = 20}
   this.drawText(this.commandName(index), rect.x, rect.y + 30, rect.width, 'center');
};

Window_MenuCommand.prototype.windowWidth = function() {
   return 692;
};

Window_MenuCommand.prototype.windowHeight = function() {
   return 195;
};

Window_MenuCommand.prototype.maxCols = function() {
   return 4;
};

Window_MenuCommand.prototype.itemHeight = function() {
   return 89;
};


Window_MenuCommand.prototype.cursorDown = function(wrap) {
  var index = this.index();
	Window_Selectable.prototype.cursorDown.call(this, wrap);
	if (index >= 4) {this.select(index - 4)}
};

Window_MenuCommand.prototype.cursorUp = function(wrap) {
  var index = this.index();
	Window_Selectable.prototype.cursorUp.call(this, wrap);
	if (index <= 3) {this.select(index + 4)}
};

Window_MenuCommand.prototype.cursorRight = function(wrap) {
  var index = this.index();
	if (index == 3) {this.select(-1)}
	if (index == 7) {this.select(3)}
	Window_Selectable.prototype.cursorRight.call(this, wrap);
};

Window_MenuCommand.prototype.cursorLeft = function(wrap) {
  var index = this.index();
	if (index == 4) {this.select(8)}
	if (index == 0) {this.select(4)}
	Window_Selectable.prototype.cursorLeft.call(this, wrap);
};








function Window_MenuStates() {
   this.initialize.apply(this, arguments);
}

Window_MenuStates.prototype = Object.create(Window_MenuStatus.prototype);
Window_MenuStates.prototype.constructor = Window_MenuStatus;


Window_MenuStates.prototype.windowHeight = function() {
   return 523;
};

Window_MenuStates.prototype.windowWidth = function() {
   return 692;
};


Window_MenuStates.prototype.drawItem = function(index) {
	var stateid = $gameActors.actor(1)._states[index]
    var rect = this.itemRect(index);
	var txt, spc, up, dn = ""
	this.changeTextColor(this.textColor(4))
	this.drawText(index + 1 + ") " + $dataStates[stateid].name, rect.x + 20, rect.y + 76, 600, 'left')
	this.changeTextColor(this.textColor(0))
	
	if ($dataStates[stateid].message1 != "") {
		up = $dataStates[stateid].message1.split(" ")
		txt = ""
		for (var j = 0; j < up.length; j++) {
			spc = ""
			if (up[j] != 0) {
				spc += "+" + up[j] + "%"
			}
			while (spc.length < 7) {spc += " "}
			txt += spc
		}
		this.drawText(txt, rect.x + 44, rect.y + 102, 810, 'left');
	}
	
	this.changeTextColor(this.textColor(2));
	if ($dataStates[stateid].message2 != "") {
		dn = $dataStates[stateid].message2.split(" ")
		txt = ""
		for (var j = 0; j < dn.length; j++) {
			spc = ""
			if (dn[j] != 0) {
				spc += "-" + dn[j] + "%"
			}
			while (spc.length < 7) {spc += " "}
			txt += spc
		}
		this.drawText(txt, rect.x + 44, rect.y + 102, 810, 'left');
	}

	
	
	this.changeTextColor(this.textColor(0))
	
	
};


Window_MenuStates.prototype.itemRect = function(index) {
    var rect = new Rectangle();
    var maxCols = this.maxCols();
    rect.width = this.itemWidth();
    rect.height = this.itemHeight();
    rect.x = index % maxCols * (rect.width + this.spacing()) - this._scrollX;
    rect.y = Math.floor(index / maxCols) * rect.height - this._scrollY;
    return rect;
};


Window_MenuStates.prototype.itemHeight = function() {
    return 60;
};

Window_MenuStates.prototype.maxItems = function() {
    return $gameActors.actor(1)._states.length;
};


Window_MenuStates.prototype.drawAllItems = function() {
		var y = 0
		var x = 4
		
		if (Utils.isMobileDevice()) {this.contents.fontSize = 22}
		
		this.drawText("Current States", x - 6, y, 680, 'center');
		this.contents.fillRect(19, y + 35, 638, 3, 'black')
		this.contents.fillRect(20, y + 36, 636, 1, 'white')		
		y += 38

		this.drawText("    Str    Nim    Spe    Sen    Mys    Res    Ins    Ero", x + 3, y, 700, 'left');


		var topIndex = this.topIndex();
		for (var i = 0; i < this.maxPageItems(); i++) {
			var index = topIndex + i;
			if (index < this.maxItems()) {
				this.drawItem(index);
			}
		}

};

Window_MenuStates.prototype.maxPageRows = function() {
	return 7
};

Window.prototype._refreshArrows = function() {
    var w = this._width;
    var h = this._height;
    var p = 24;
    var q = p/2;
    var sx = 96+p;
    var sy = 0+p;
    this._downArrowSprite.bitmap = this._windowskin;
    this._downArrowSprite.anchor.x = 0.5;
    this._downArrowSprite.anchor.y = 0.5;
    this._downArrowSprite.setFrame(sx+q, sy+q+p, p, q);
    this._downArrowSprite.move(w - 17, h-q);
    this._upArrowSprite.bitmap = this._windowskin;
    this._upArrowSprite.anchor.x = 0.5;
    this._upArrowSprite.anchor.y = 0.5;
    this._upArrowSprite.setFrame(sx+q, sy, p, q);
    this._upArrowSprite.move(w - 17, q);
};





//main menu button
var NK_Scene_Map_callMenu = Scene_Map.prototype.callMenu
Scene_Map.prototype.callMenu = function() {
	$gameSwitches.setValue(116, false) //save text
	$gameVariables.setValue(5, 0); //used item
	$gameMessage.setFaceImage("", 0);
	$gameMessage.setBackground(2);
	$gameMessage.setPositionType(2);
	$gameMessage.addText("``");
	$gameScreen.erasePicture(456)
	$gameScreen.erasePicture(461)
	if ($gameSelfSwitches.value([4, 20, 'A'])) { //ng+ active
		$gameSwitches.setValue(179, false)
	}
	$gameScreen.movePicture(463, 0, pic(463)._x, pic(463)._y, 100, 100, 0, 0, 1);
	sixset(26,5,0)
	$gameSwitches.setValue(179, false) //hide hud
	sset(117, true)
	
//	this._myWindow.visible = false
	
	NK_Scene_Map_callMenu.call(this)
	
};


Window_GameEnd.prototype.makeCommandList = function() {
    this.addCommand("To Title", 'toTitle');
    this.addCommand("Quit Game", 'Quit');
    this.addCommand("Return to Game",  'cancel');
};

Scene_GameEnd.prototype.createCommandWindow = function() {
    this._commandWindow = new Window_GameEnd();
    this._commandWindow.setHandler('toTitle',  this.commandToTitle.bind(this));
    this._commandWindow.setHandler('Quit',  	 this.commandQuit.bind(this));
    this._commandWindow.setHandler('cancel',   this.popScene.bind(this));
    this.addWindow(this._commandWindow);
	
	if (ConfigManager.touchbuttons) {
		this.sprite = new Sprite(ImageManager.loadPicture('zBtnBack'))
		this.sprite.x = -ConfigManager.movebtn //move x
		this.addChild(this.sprite)
	}
	
    this._helpWindow = new Window_Help(3);
	var time = Math.round((Graphics.frameCount - v(231)) / 60)
	var min = 0
	
	if (time > 59) {
		min = Math.floor(time / 60)
		time -= (min * 60)
	}
	
	if (min == 1) {
		if (time == 0) {time = min + " minute"}
		else if (time == 1){time = min + " minute and " + time + " second"}
		else {time = min + " minute and " + time + " seconds"}
	}
	else if (min >= 2) {
		if (time == 0) {time = min + " minutes"}
		else if (time == 1){time = min + " minutes and " + time + " second"}
		else {time = min + " minutes and " + time + " seconds"}
	}
	else {
		if (time == 1){time += " second"}
		else {time += " seconds"}
	}
	
    this._helpWindow.setText("It's been " + time + " since your last save.\n\n" + "Quit game?");
    this.addWindow(this._helpWindow);
};

Scene_GameEnd.prototype.commandQuit = function() {
    this.fadeOutAll();
    SceneManager.exit();
};

Scene_GameEnd.prototype.commandToTitle = function() {
//    this.fadeOutAll();
    SceneManager.goto(Scene_Title);
};

Window_GameEnd.prototype.windowWidth = function() {
    return 692;
};

Window_GameEnd.prototype.updatePlacement = function() {
    this.x = 62
    this.y = 133
};

Window_GameEnd.prototype.drawItem = function(index) {
    var rect = this.itemRectForText(index);
    var align = this.itemTextAlign();
    this.resetTextColor();
    this.changePaintOpacity(this.isCommandEnabled(index));
		if (Utils.isMobileDevice()) {this.contents.fontSize = 20}
    this.drawText(this.commandName(index), rect.x, rect.y + 18, rect.width, 'center');
};
